const OPENAPI = `{"openapi":"3.1.0","info":{"title":"Orchestratorplugin","description":"APItointeractwithorchestratorplugin","license":{"name":"Apache2.0","url":"http://www.apache.org/licenses/LICENSE-2.0.html"},"version":"0.0.1"},"servers":[{"url":"/"}],"paths":{"/v2/workflows/overview":{"post":{"operationId":"getWorkflowsOverview","description":"Returnsthekeyfieldsoftheworkflowincludingdataonthelastruninstance","requestBody":{"required":false,"description":"Paginationandfilters","content":{"application/json":{"schema":{"$ref":"#/components/schemas/SearchRequest"}}}},"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"$ref":"#/components/schemas/WorkflowOverviewListResultDTO"}}}},"500":{"description":"Errorfetchingworkflowoverviews","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/overview/entity":{"post":{"operationId":"getWorkflowsOverviewForEntity","description":"Returnsthekeyfieldsoftheworkflowincludingdataonthelastruninstance","requestBody":{"required":false,"description":"Targetentityreferenceandannotationworkflowids","content":{"application/json":{"schema":{"type":"object","properties":{"targetEntity":{"type":"string"},"annotationWorkflowIds":{"type":"array","items":{"type":"string"}}}}}}},"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"$ref":"#/components/schemas/WorkflowOverviewListResultDTO"}}}},"500":{"description":"Errorfetchingworkflowoverviewsforentity","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/{workflowId}/overview":{"get":{"operationId":"getWorkflowOverviewById","description":"Returnsthekeyfieldsoftheworkflowincludingdataonthelastruninstance","parameters":[{"name":"workflowId","in":"path","required":true,"description":"Uniqueidentifieroftheworkflow","schema":{"type":"string"}}],"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"$ref":"#/components/schemas/WorkflowOverviewDTO"}}}},"500":{"description":"Errorfetchingworkflowoverview","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/{workflowId}/source":{"get":{"operationId":"getWorkflowSourceById","description":"Gettheworkflow'sdefinition","parameters":[{"name":"workflowId","in":"path","description":"IDoftheworkflowtofetch","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"Success","content":{"text/plain":{"schema":{"type":"string"}}}},"500":{"description":"Errorfetchingworkflowsourcebyid","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/{workflowId}/inputSchema":{"get":{"operationId":"getWorkflowInputSchemaById","description":"Gettheworkflowinputschema.Itdefinestheinputfieldsoftheworkflow","parameters":[{"name":"workflowId","in":"path","description":"IDoftheworkflowtofetch","required":true,"schema":{"type":"string"}},{"name":"instanceId","in":"query","description":"IDofinstance","schema":{"type":"string"}}],"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"$ref":"#/components/schemas/InputSchemaResponseDTO"}}}},"500":{"description":"Errorfetchingworkflowinputschemabyid","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/{workflowId}/pingWorkflowService":{"get":{"operationId":"pingWorkflowServiceById","description":"ReturnstrueiftheworkflowserviceisupforthegivenworkflowID.","parameters":[{"name":"workflowId","in":"path","description":"IDoftheworkflowtofetch","required":true,"schema":{"type":"string"}}],"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"type":"boolean"}}}},"500":{"description":"Errorpingingworkflowservicebyid","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/instances":{"post":{"operationId":"getInstances","summary":"Getinstances","description":"Retrieveanarrayofworkflowexecutions(instances)","requestBody":{"required":false,"description":"Parametersforretrievinginstances","content":{"application/json":{"schema":{"$ref":"#/components/schemas/SearchRequest"}}}},"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ProcessInstanceListResultDTO"}}}},"500":{"description":"Errorfetchinginstances","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/{workflowId}/instances":{"post":{"operationId":"getWorkflowInstances","summary":"Getinstancesforaspecificworkflow","description":"Retrieveanarrayofworkflowexecutions(instances)forthegivenworkflow","parameters":[{"name":"workflowId","in":"path","required":true,"description":"IDoftheworkflow","schema":{"type":"string"}}],"requestBody":{"required":false,"description":"Parametersforretrievingworkflowinstances","content":{"application/json":{"schema":{"$ref":"#/components/schemas/SearchRequest"}}}},"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ProcessInstanceListResultDTO"}}}},"500":{"description":"Errorfetchinginstances","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/instances/{instanceId}":{"get":{"summary":"GetWorkflowInstancebyID","description":"Getaworkflowexecution/run(instance)","operationId":"getInstanceById","parameters":[{"name":"instanceId","in":"path","required":true,"description":"IDoftheworkflowinstance","schema":{"type":"string"}}],"responses":{"200":{"description":"Successfulresponse","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ProcessInstanceDTO"}}}},"500":{"description":"Errorfetchinginstance","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/instances/statuses":{"get":{"operationId":"getWorkflowStatuses","summary":"Getworkflowstatuslist","description":"Retrievearraywiththestatusofallinstances","responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"type":"array","items":{"$ref":"#/components/schemas/WorkflowRunStatusDTO"}}}}},"500":{"description":"Errorfetchingworkflowstatuses","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/{workflowId}/execute":{"post":{"summary":"Executeaworkflow","description":"Executeaworkflow","operationId":"executeWorkflow","parameters":[{"name":"workflowId","in":"path","description":"IDoftheworkflowtoexecute","required":true,"schema":{"type":"string"}}],"requestBody":{"required":true,"content":{"application/json":{"schema":{"$ref":"#/components/schemas/ExecuteWorkflowRequestDTO"}}}},"responses":{"200":{"description":"Successfulexecution","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ExecuteWorkflowResponseDTO"}}}},"500":{"description":"InternalServerError","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/{workflowId}/{instanceId}/retrigger":{"post":{"summary":"Retriggeraninstance","description":"Retriggeraninstance","operationId":"retriggerInstance","parameters":[{"name":"workflowId","in":"path","description":"IDoftheworkflow","required":true,"schema":{"type":"string"}},{"name":"instanceId","in":"path","description":"IDoftheinstancetoretrigger","required":true,"schema":{"type":"string"}}],"requestBody":{"required":true,"content":{"application/json":{"schema":{"$ref":"#/components/schemas/RetriggerInstanceRequestDTO"}}}},"responses":{"200":{"description":"Success","content":{"application/json":{"schema":{"type":"object"}}}},"500":{"description":"InternalServerError","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}},"/v2/workflows/instances/{instanceId}/abort":{"delete":{"summary":"Abortaworkflowinstance","operationId":"abortWorkflow","description":"AbortsaworkflowinstanceidentifiedbytheprovidedinstanceId.","parameters":[{"name":"instanceId","in":"path","required":true,"description":"Theidentifieroftheworkflowinstancetoabort.","schema":{"type":"string"}}],"responses":{"200":{"description":"Successfuloperation","content":{"text/plain":{"schema":{"type":"string"}}}},"500":{"description":"Errorabortingworkflow","content":{"application/json":{"schema":{"$ref":"#/components/schemas/ErrorResponse"}}}}}}}},"components":{"schemas":{"ErrorResponse":{"description":"TheErrorResponseobjectrepresentsacommonstructureforhandlingerrorsinAPIresponses.Itincludesessentialinformationabouttheerror,suchastheerrormessageandadditionaloptionaldetails.","type":"object","properties":{"message":{"description":"Astringprovidingaconciseandhuman-readabledescriptionoftheencounterederror.ThisfieldisrequiredintheErrorResponseobject.","type":"string","default":"internalservererror"},"additionalInfo":{"description":"Anoptionalfieldthatcancontainadditionalinformationorcontextabouttheerror.Itprovidesflexibilityforincludingextradetailsbasedonspecificerrorscenarios.","type":"string"}},"required":["message"]},"GetOverviewsRequestParams":{"type":"object","properties":{"paginationInfo":{"$ref":"#/components/schemas/PaginationInfoDTO"},"filters":{"$ref":"#/components/schemas/SearchRequest"}}},"WorkflowOverviewListResultDTO":{"type":"object","properties":{"overviews":{"type":"array","items":{"$ref":"#/components/schemas/WorkflowOverviewDTO"},"minItems":0},"paginationInfo":{"$ref":"#/components/schemas/PaginationInfoDTO"}}},"WorkflowOverviewDTO":{"type":"object","properties":{"workflowId":{"type":"string","description":"Workflowuniqueidentifier","minLength":1},"name":{"type":"string","description":"Workflowname","minLength":1},"format":{"$ref":"#/components/schemas/WorkflowFormatDTO"},"lastRunId":{"type":"string"},"lastTriggeredMs":{"type":"number","minimum":0},"lastRunStatus":{"$ref":"#/components/schemas/ProcessInstanceStatusDTO"},"description":{"type":"string"},"isAvailable":{"type":"boolean"}},"required":["workflowId","format"]},"PaginationInfoDTO":{"type":"object","properties":{"pageSize":{"type":"number"},"offset":{"type":"number"},"orderDirection":{"enum":["ASC","DESC"]},"orderBy":{"type":"string"}},"additionalProperties":false},"WorkflowFormatDTO":{"type":"string","description":"Formatoftheworkflowdefinition","enum":["yaml","json"]},"WorkflowListResultDTO":{"type":"object","properties":{"items":{"type":"array","items":{"$ref":"#/components/schemas/WorkflowDTO"}},"paginationInfo":{"$ref":"#/components/schemas/PaginationInfoDTO"}},"required":["items","paginationInfo"]},"WorkflowDTO":{"type":"object","properties":{"id":{"type":"string","description":"Workflowuniqueidentifier","minLength":1},"name":{"type":"string","description":"Workflowname","minLength":1},"format":{"$ref":"#/components/schemas/WorkflowFormatDTO"},"description":{"type":"string","description":"Descriptionoftheworkflow"},"annotations":{"type":"array","items":{"type":"string"}}},"required":["id","format"]},"ProcessInstanceListResultDTO":{"type":"object","properties":{"items":{"type":"array","items":{"$ref":"#/components/schemas/ProcessInstanceDTO"}},"paginationInfo":{"$ref":"#/components/schemas/PaginationInfoDTO"}}},"ProcessInstanceDTO":{"type":"object","properties":{"id":{"type":"string"},"processId":{"type":"string"},"processName":{"type":"string"},"state":{"$ref":"#/components/schemas/ProcessInstanceStatusDTO"},"endpoint":{"type":"string"},"serviceUrl":{"type":"string"},"start":{"type":"string"},"end":{"type":"string"},"duration":{"type":"string"},"description":{"type":"string"},"workflowdata":{"$ref":"#/components/schemas/WorkflowDataDTO"},"initiatorEntity":{"type":"string"},"targetEntity":{"type":"string"},"executionSummary":{"type":"array","items":{"type":"string"}},"nodes":{"type":"array","items":{"$ref":"#/components/schemas/NodeInstanceDTO"}},"error":{"$ref":"#/components/schemas/ProcessInstanceErrorDTO"}},"required":["id","processId","nodes"]},"WorkflowDataDTO":{"type":"object","properties":{"result":{"$ref":"#/components/schemas/WorkflowResultDTO"}},"additionalProperties":true},"WorkflowResultDTO":{"description":"Resultofaworkflowexecution","type":"object","properties":{"message":{"description":"High-levelsummaryofthecurrentstatus,free-formtext,humanreadable.","type":"string"},"nextWorkflows":{"description":"Listofworkflowssuggestedtorunnext.Itemsatlowerindexesareofhigherpriority.","type":"array","items":{"type":"object","properties":{"id":{"description":"Workflowidentifier","type":"string"},"name":{"description":"Humanreadabletitledescribingtheworkflow.","type":"string"}},"required":["id","name"]}},"outputs":{"description":"Additionalstructuredoutputofworkflowprocessing.Thiscancontainidentifiersofcreatedresources,linkstoresources,logsorotheroutput.","type":"array","items":{"type":"object","properties":{"key":{"description":"Uniqueidentifieroftheoption.Preferablyhuman-readable.","type":"string"},"value":{"description":"Freeformvalueoftheoption.","anyOf":[{"type":"string"},{"type":"number"}]},"format":{"description":"Moredetailedtypeofthe'value'property.Defaultsto'text'.","enum":["text","number","link","markdown"]}},"required":["key","value"]}}}},"ProcessInstanceStatusDTO":{"type":"string","description":"Statusoftheworkflowrun","enum":["ACTIVE","ERROR","COMPLETED","ABORTED","SUSPENDED","PENDING"]},"WorkflowRunStatusDTO":{"type":"object","properties":{"key":{"type":"string"},"value":{"type":"string"}}},"ExecuteWorkflowRequestDTO":{"type":"object","properties":{"inputData":{"type":"object","additionalProperties":true},"authTokens":{"type":"array","items":{"$ref":"#/components/schemas/AuthToken"},"minItems":0,"additionalProperties":true},"targetEntity":{"type":"string","description":"Theentitystringidentifiertoexecutetheworkflowfor"}}},"RetriggerInstanceRequestDTO":{"type":"object","properties":{"authTokens":{"type":"array","items":{"$ref":"#/components/schemas/AuthToken"},"minItems":0,"additionalProperties":true}}},"AuthToken":{"type":"object","properties":{"provider":{"description":"Theauthtokenprovidername","type":"string"},"token":{"description":"Theauthtokenitselfretrievedfromtheabovespecifiedprovidername","type":"string"}},"required":["provider","token"],"additionalProperties":false},"ExecuteWorkflowResponseDTO":{"type":"object","properties":{"id":{"type":"string"}},"required":["id"]},"WorkflowProgressDTO":{"allOf":[{"$ref":"#/components/schemas/NodeInstanceDTO"},{"type":"object","properties":{"status":{"$ref":"#/components/schemas/ProcessInstanceStatusDTO"},"error":{"$ref":"#/components/schemas/ProcessInstanceErrorDTO"}}}]},"NodeInstanceDTO":{"type":"object","properties":{"__typename":{"type":"string","default":"NodeInstance","description":"Typename"},"id":{"type":"string","description":"NodeinstanceID"},"name":{"type":"string","description":"Nodename"},"type":{"type":"string","description":"Nodetype"},"enter":{"type":"string","description":"Datewhenthenodewasentered"},"exit":{"type":"string","description":"Datewhenthenodewasexited(optional)"},"definitionId":{"type":"string","description":"DefinitionID"},"nodeId":{"type":"string","description":"NodeID"}},"required":["id"]},"ProcessInstanceErrorDTO":{"type":"object","properties":{"__typename":{"type":"string","default":"ProcessInstanceError","description":"Typename"},"nodeDefinitionId":{"type":"string","description":"NodedefinitionID"},"message":{"type":"string","description":"Errormessage(optional)"}},"required":["nodeDefinitionId"]},"SearchRequest":{"type":"object","properties":{"filters":{"$ref":"#/components/schemas/Filter"},"paginationInfo":{"$ref":"#/components/schemas/PaginationInfoDTO"}}},"Filter":{"oneOf":[{"$ref":"#/components/schemas/LogicalFilter"},{"$ref":"#/components/schemas/FieldFilter"},{"$ref":"#/components/schemas/NestedFilter"}]},"NestedFilter":{"type":"object","required":["field","nested"],"properties":{"field":{"type":"string"},"nested":{"oneOf":[{"$ref":"#/components/schemas/FieldFilter"},{"$ref":"#/components/schemas/NestedFilter"}]}}},"LogicalFilter":{"type":"object","required":["operator","filters"],"properties":{"operator":{"type":"string","enum":["AND","OR","NOT"]},"filters":{"type":"array","items":{"$ref":"#/components/schemas/Filter"}}}},"FieldFilter":{"type":"object","required":["field","operator","value"],"properties":{"field":{"type":"string"},"operator":{"type":"string","enum":["EQ","GT","GTE","LT","LTE","IN","IS_NULL","LIKE","BETWEEN"]},"value":{"oneOf":[{"type":"string"},{"type":"number"},{"type":"boolean"},{"type":"array","items":{"oneOf":[{"type":"string"},{"type":"number"},{"type":"boolean"}]}}]}}},"InputSchemaResponseDTO":{"type":"object","properties":{"inputSchema":{"type":"object"},"data":{"type":"object"}}}}}}`;
const openApiDocument = JSON.parse(OPENAPI);

export { openApiDocument };
//# sourceMappingURL=definition.esm.js.map
