import { Actiondatafilter } from './actiondatafilter';
import { Eventref } from './eventref';
import { Functionref } from './functionref';
import { Subflowref } from './subflowref';
import { Sleep } from './sleep';
export declare class Action {
    sourceModel?: Action;
    /**
     * Unique action identifier
     */
    id?: string;
    /**
     * Unique action definition name
     */
    name?: string;
    functionRef?: string | Functionref;
    eventRef?: Eventref;
    subFlowRef?: string | Subflowref;
    sleep?: Sleep;
    /**
     * References a defined workflow retry definition. If not defined the default retry policy is assumed
     */
    retryRef?: string;
    /**
     * List of unique references to defined workflow errors for which the action should not be retried. Used only when `autoRetries` is set to `true`
     */
    nonRetryableErrors?: [string, ...string[]];
    /**
     * List of unique references to defined workflow errors for which the action should be retried. Used only when `autoRetries` is set to `false`
     */
    retryableErrors?: [string, ...string[]];
    actionDataFilter?: Actiondatafilter;
    /**
     * Expression, if defined, must evaluate to true for this action to be performed. If false, action is disregarded
     */
    condition?: string;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Action} without deleted properties.
     */
    normalize: () => Action;
}
//# sourceMappingURL=action.d.ts.map