import { WorkflowExecTimeout } from './workflowExecTimeout';
export declare class Continueasdef {
    sourceModel?: Continueasdef;
    /**
     * Unique id of the workflow to continue execution as
     */
    workflowId: string;
    /**
     * Version of the workflow to continue execution as
     */
    version?: string;
    /**
     * If string type, an expression which selects parts of the states data output to become the workflow data input of continued execution. If object type, a custom object to become the workflow data input of the continued execution
     */
    data?: string | {
        [key: string]: any;
    };
    /**
     * Workflow execution timeout to be used by the workflow continuing execution. Overwrites any specific settings set by that workflow
     */
    workflowExecTimeout?: WorkflowExecTimeout;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Exectimeout} without deleted properties.
     */
    normalize: () => Continueasdef;
}
//# sourceMappingURL=continueasdef.d.ts.map