import { End } from './end';
import { Transition } from './transition';
export declare class Error {
    sourceModel?: Error;
    /**
     * Reference to a unique workflow error definition. Used of errorRefs is not used
     */
    errorRef: string;
    /**
     * References one or more workflow error definitions. Used if errorRef is not used
     */
    errorRefs?: [string, ...string[]];
    transition: string | Transition;
    end?: boolean | End;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Error} without deleted properties.
     */
    normalize: () => Error;
}
//# sourceMappingURL=error.d.ts.map