export declare class Eventref {
    sourceModel?: Eventref;
    /**
     * Reference to the unique name of a 'produced' event definition
     */
    triggerEventRef: string;
    /**
     * Reference to the unique name of a 'consumed' event definition
     */
    resultEventRef: string;
    /**
     * Maximum amount of time (ISO 8601 format) to wait for the result event. If not defined it should default to the actionExecutionTimeout
     */
    resultEventTimeout?: string;
    /**
     * If string type, an expression which selects parts of the states data output to become the data (payload) of the event referenced by 'triggerEventRef'. If object type, a custom object to become the data (payload) of the event referenced by 'triggerEventRef'.
     */
    data?: string | {
        [key: string]: any;
    };
    /**
     * Add additional extension context attributes to the produced event
     */
    contextAttributes?: {
        [name: string]: string;
    };
    /**
     * Specifies if the function should be invoked sync or async. Default is sync.
     */
    invoke?: 'sync' | 'async';
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Eventref} without deleted properties.
     */
    normalize: () => Eventref;
}
//# sourceMappingURL=eventref.d.ts.map