import { End } from './end';
import { Error } from './error';
import { Metadata } from './metadata';
import { Onevents } from './onevents';
import { Statedatafilter } from './statedatafilter';
import { Transition } from './transition';
import { ActionExecTimeout, EventTimeout } from './types';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Eventstate {
    sourceModel?: Eventstate;
    /**
     * Unique State id
     */
    id?: string;
    /**
     * State name
     */
    name: string;
    /**
     * State type
     */
    type: 'event';
    /**
     * If true consuming one of the defined events causes its associated actions to be performed. If false all of the defined events must be consumed in order for actions to be performed
     */
    exclusive?: boolean;
    /**
     * Define the events to be consumed and optional actions to be performed
     */
    onEvents: Onevents[];
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
        actionExecTimeout?: ActionExecTimeout;
        eventTimeout?: EventTimeout;
    };
    stateDataFilter?: Statedatafilter;
    /**
     * States error handling definitions
     */
    onErrors?: Error[];
    transition?: string | Transition;
    end: boolean | End;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Eventstate} without deleted properties.
     */
    normalize: () => Eventstate;
}
//# sourceMappingURL=eventstate.d.ts.map