import { Metadata } from './metadata';
export declare class Function {
    sourceModel?: Function;
    /**
     * Unique function name
     */
    name: string;
    /**
     * If type is `rest`, <path_to_openapi_definition>#<operation_id>. If type is `asyncapi`, <path_to_asyncapi_definition>#<operation_id>. If type is `rpc`, <path_to_grpc_proto_file>#<service_name>#<service_method>. If type is `graphql`, <url_to_graphql_endpoint>#<literal \"mutation\" or \"query\">#<query_or_mutation_name>. If type is `odata`, <URI_to_odata_service>#<Entity_Set_Name>. If type is `expression`, defines the workflow expression.
     */
    operation: string;
    /**
     * Defines the function type. Is either `rest`, `asyncapi, `rpc`, `graphql`, `odata`, `expression`, or `custom`. Default is `rest`
     */
    type?: 'rest' | 'asyncapi' | 'rpc' | 'graphql' | 'odata' | 'expression' | 'custom';
    /**
     * References an auth definition name to be used to access to resource defined in the operation parameter
     */
    authRef?: string;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Function} without deleted properties.
     */
    normalize: () => Function;
}
//# sourceMappingURL=function.d.ts.map