import { End } from './end';
import { Metadata } from './metadata';
import { Statedatafilter } from './statedatafilter';
import { Transition } from './transition';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Injectstate {
    sourceModel?: Injectstate;
    /**
     * Unique state id
     */
    id?: string;
    /**
     * State name
     */
    name?: string;
    /**
     * State type
     */
    type?: 'inject';
    /**
     * State end definition
     */
    end?: boolean | End;
    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     */
    data?: {
        [key: string]: any;
    };
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
    };
    /**
     * State data filter
     */
    stateDataFilter?: Statedatafilter;
    /**
     * Next transition of the workflow after injection has completed
     */
    transition?: string | Transition;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    /**
     * If true, this state is used to compensate another state. Default is false
     */
    usedForCompensation?: boolean;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Injectstate} without deleted properties.
     */
    normalize: () => Injectstate;
}
//# sourceMappingURL=injectstate.d.ts.map