import { Metadata } from './metadata';
export declare class Oauth2propsdef {
    /**
     * String or a workflow expression. Contains the authority information
     */
    authority?: string;
    /**
     * Defines the grant type
     */
    grantType: 'password' | 'clientCredentials' | 'tokenExchange';
    /**
     * String or a workflow expression. Contains the client identifier
     */
    clientId: string;
    /**
     * Workflow secret or a workflow expression. Contains the client secret
     */
    clientSecret?: string;
    /**
     * Array containing strings or workflow expressions. Contains the OAuth2 scopes
     */
    scopes?: [string, ...string[]];
    /**
     * String or a workflow expression. Contains the user name. Used only if grantType is 'resourceOwner'
     */
    username?: string;
    /**
     * String or a workflow expression. Contains the user password. Used only if grantType is 'resourceOwner'
     */
    password?: string;
    /**
     * Array containing strings or workflow expressions. Contains the OAuth2 audiences
     */
    audiences?: [string, ...string[]];
    /**
     * String or a workflow expression. Contains the subject token
     */
    subjectToken?: string;
    /**
     * String or a workflow expression. Contains the requested subject
     */
    requestedSubject?: string;
    /**
     * String or a workflow expression. Contains the requested issuer
     */
    requestedIssuer?: string;
    metadata?: Metadata;
    constructor(model: any);
}
//# sourceMappingURL=oauth2propsdef.d.ts.map