import { Action } from './action';
import { End } from './end';
import { Error } from './error';
import { Metadata } from './metadata';
import { Statedatafilter } from './statedatafilter';
import { Transition } from './transition';
import { ActionExecTimeout } from './types';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Operationstate {
    sourceModel?: Operationstate;
    /**
     * Unique State id
     */
    id?: string;
    /**
     * State name
     */
    name?: string;
    /**
     * State type
     */
    type?: 'operation';
    /**
     * State end definition
     */
    end?: boolean | End;
    /**
     * State data filter
     */
    stateDataFilter?: Statedatafilter;
    /**
     * Specifies whether actions are performed in sequence or in parallel
     */
    actionMode?: 'sequential' | 'parallel';
    /**
     * Actions to be performed
     */
    actions?: Action[];
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
        actionExecTimeout?: ActionExecTimeout;
    };
    /**
     * States error handling definitions
     */
    onErrors?: Error[];
    /**
     * Next transition of the workflow after all the actions have been performed
     */
    transition?: string | Transition;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    /**
     * If true, this state is used to compensate another state. Default is false
     */
    usedForCompensation?: boolean;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Operationstate} without deleted properties.
     */
    normalize: () => Operationstate;
}
//# sourceMappingURL=operationstate.d.ts.map