import { Branch } from './branch';
import { End } from './end';
import { Error } from './error';
import { Metadata } from './metadata';
import { Statedatafilter } from './statedatafilter';
import { Transition } from './transition';
import { BranchExecTimeout } from './types';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Parallelstate {
    sourceModel?: Parallelstate;
    /**
     * Unique State id
     */
    id?: string;
    /**
     * State name
     */
    name?: string;
    /**
     * State type
     */
    type?: 'parallel';
    /**
     * State end definition
     */
    end?: boolean | End;
    /**
     * State data filter
     */
    stateDataFilter?: Statedatafilter;
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
        branchExecTimeout?: BranchExecTimeout;
    };
    /**
     * Branch Definitions
     */
    branches?: Branch[];
    /**
     * Option types on how to complete branch execution.
     */
    completionType?: 'allOf' | 'atLeast';
    /**
     * Used when completionType is set to 'atLeast' to specify the minimum number of branches that must complete before the state will transition.
     */
    numCompleted?: number | string;
    /**
     * States error handling definitions
     */
    onErrors?: Error[];
    /**
     * Next transition of the workflow after all branches have completed execution
     */
    transition?: string | Transition;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    /**
     * If true, this state is used to compensate another state. Default is false
     */
    usedForCompensation?: boolean;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Parallelstate} without deleted properties.
     */
    normalize: () => Parallelstate;
}
//# sourceMappingURL=parallelstate.d.ts.map