import { End } from './end';
import { Error } from './error';
import { Metadata } from './metadata';
import { Statedatafilter } from './statedatafilter';
import { Transition } from './transition';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Sleepstate {
    sourceModel?: Sleepstate;
    /**
     * Unique State id
     */
    id?: string;
    /**
     * State name
     */
    name?: string;
    /**
     * State type
     */
    type?: 'sleep';
    /**
     * State end definition
     */
    end?: boolean | End;
    /**
     * State data filter
     */
    stateDataFilter?: Statedatafilter;
    /**
     * Duration (ISO 8601 duration format) to sleep
     */
    duration?: string;
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
    };
    /**
     * States error handling definitions
     */
    onErrors?: Error[];
    /**
     * Next transition of the workflow after the workflow sleep
     */
    transition?: string | Transition;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    /**
     * If true, this state is used to compensate another state. Default is false
     */
    usedForCompensation?: boolean;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Delaystate} without deleted properties.
     */
    normalize: () => Sleepstate;
}
//# sourceMappingURL=sleepstate.d.ts.map