export declare class Subflowref {
    sourceModel?: Subflowref;
    /**
     * Unique id of the sub-workflow to be invoked
     */
    workflowId: string;
    /**
     * Version of the sub-workflow to be invoked
     */
    version?: string;
    /**
     * If invoke is 'async', specifies how subflow execution should behave when parent workflow completes. Default is 'terminate'
     */
    onParentComplete?: 'continue' | 'terminate';
    /**
     * Specifies if the subflow should be invoked sync or async
     */
    invoke?: 'sync' | 'async';
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Subflowref} without deleted properties.
     */
    normalize: () => Subflowref;
}
//# sourceMappingURL=subflowref.d.ts.map