import { Metadata } from './metadata';
import { Startdef } from './startdef';
import { Timeouts } from './timeouts';
import { Specification } from '.';
import { Auth, Errors, Events, Functions, Retries, Secrets, States } from './types';
export declare class Workflow {
    sourceModel?: Workflow;
    /**
     * Workflow unique identifier
     */
    id: string;
    /**
     * Domain-specific workflow identifier
     */
    key?: string;
    /**
     * Workflow name
     */
    name?: string;
    /**
     * Workflow description
     */
    description?: string;
    /**
     * Workflow version
     */
    version?: string;
    /**
     * List of helpful terms describing the workflows intended purpose, subject areas, or other important qualities
     */
    annotations?: [string, ...string[]];
    dataInputSchema?: string | {
        /**
         * URI of the JSON Schema used to validate the workflow data input
         */
        schema: string;
        /**
         * Determines if workflow execution should continue if there are validation errors
         */
        failOnValidationErrors: boolean;
    };
    secrets?: Secrets;
    constants?: string | {
        [key: string]: any;
    };
    start?: string | Startdef;
    /**
     * Serverless Workflow schema version
     */
    specVersion: string;
    /**
     * Identifies the expression language used for workflow expressions. Default is 'jq'
     */
    expressionLang?: string;
    timeouts?: string | Timeouts;
    errors?: Errors;
    /**
     * If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'workflowExecTimeout'
     */
    keepActive?: boolean;
    metadata?: Metadata;
    events?: Events;
    functions?: Functions;
    /**
     * If set to true, actions should automatically be retried on unchecked errors. Default is false
     */
    autoRetries?: boolean;
    retries?: Retries;
    auth?: Auth;
    /**
     * State definitions
     */
    states: States;
    constructor(model: any);
    /**
     * Parses the provided string as Workflow
     * @param {string} data The JSON or YAML workflow to parse
     * @returns {Workflow} The parse Workflow
     */
    static fromSource(value: string): Specification.Workflow;
    /**
     * Stringifies the provided workflow to the JSON format
     * @param {Workflow} workflow The workflow to strigify
     * @returns {string} The workflow as JSON
     */
    static toJson(workflow: Workflow): string;
    /**
     * Stringifies the provided workflow to the YAML format
     * @param {Workflow} workflow The workflow to strigify
     * @returns {string} The workflow as YAML
     */
    static toYaml(workflow: Workflow): string;
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Workflow} without deleted properties.
     */
    normalize: () => Workflow;
}
//# sourceMappingURL=workflow.d.ts.map