/// <reference types="node" />
import { CloudEventV1 } from "../..";
import { Message, Binding } from "..";
export { Kafka };
export type { KafkaMessage, KafkaEvent };
/**
 * Bindings for Kafka transport
 * @implements {@linkcode Binding}
 */
declare const Kafka: Binding;
declare type Key = string | Buffer;
/**
 * Extends the base Message type to include
 * Kafka-specific fields
 */
interface KafkaMessage<T = string> extends Message {
    key: Key;
    value: T | string | Buffer | unknown;
    timestamp?: string;
}
/**
 * Extends the base CloudEventV1 interface to include a `partitionkey` field
 * which is explicitly mapped to KafkaMessage#key
 */
interface KafkaEvent<T> extends CloudEventV1<T> {
    /**
     * Maps to KafkaMessage#key per
     * https://github.com/cloudevents/spec/blob/v1.0.1/kafka-protocol-binding.md#31-key-mapping
     */
    partitionkey: Key;
}
