import { Binding, Message, Headers } from "../..";
export { MQTT, MQTTMessageFactory };
export type { MQTTMessage };
/**
 * Extends the base {@linkcode Message} interface to include MQTT attributes, some of which
 * are aliases of the {Message} attributes.
 */
interface MQTTMessage<T> extends Message<T> {
    /**
     * Identifies this message as a PUBLISH packet. MQTTMessages created with
     * the `binary` and `structured` Serializers will contain a "Content Type"
     * property in the PUBLISH record.
     * @see https://github.com/cloudevents/spec/blob/v1.0.1/mqtt-protocol-binding.md#3-mqtt-publish-message-mapping
     */
    PUBLISH: Record<string, string | undefined> | undefined;
    /**
     * Alias of {Message#body}
     */
    payload: T | undefined;
    /**
     * Alias of {Message#headers}
     */
    "User Properties": Headers | undefined;
}
/**
 * Binding for MQTT transport support
 * @implements @linkcode Binding
 */
declare const MQTT: Binding;
/**
 * A helper function to create an MQTTMessage<T> object, with "User Properties" as an alias
 * for "headers" and "payload" an alias for body, and a "PUBLISH" record with a "Content Type"
 * property.
 * @param {string} contentType the "Content Type" attribute on PUBLISH
 * @param {Record<string, unknown>} headers the headers and "User Properties"
 * @param {T} body the message body/payload
 * @returns {MQTTMessage<T>} a message initialized with the provided attributes
 */
declare function MQTTMessageFactory<T>(contentType: string, headers: Record<string, unknown>, body: T): MQTTMessage<T>;
