"use strict";
module.exports = validate20;
module.exports.default = validate20;
const schema22 = { "$schema": "http://json-schema.org/draft-07/schema#", "description": "CloudEvents Specification JSON Schema", "type": "object", "properties": { "id": { "description": "Identifies the event.", "$ref": "#/definitions/iddef", "examples": ["A234-1234-1234"] }, "source": { "description": "Identifies the context in which an event happened.", "$ref": "#/definitions/sourcedef", "examples": ["https://github.com/cloudevents", "mailto:cncf-wg-serverless@lists.cncf.io", "urn:uuid:6e8bc430-9c3a-11d9-9669-0800200c9a66", "cloudevents/spec/pull/123", "/sensors/tn-1234567/alerts", "1-555-123-4567"] }, "specversion": { "description": "The version of the CloudEvents specification which the event uses.", "$ref": "#/definitions/specversiondef", "examples": ["1.0"] }, "type": { "description": "Describes the type of event related to the originating occurrence.", "$ref": "#/definitions/typedef", "examples": ["com.github.pull_request.opened", "com.example.object.deleted.v2"] }, "datacontenttype": { "description": "Content type of the data value. Must adhere to RFC 2046 format.", "$ref": "#/definitions/datacontenttypedef", "examples": ["text/xml", "application/json", "image/png", "multipart/form-data"] }, "dataschema": { "description": "Identifies the schema that data adheres to.", "$ref": "#/definitions/dataschemadef" }, "subject": { "description": "Describes the subject of the event in the context of the event producer (identified by source).", "$ref": "#/definitions/subjectdef", "examples": ["mynewfile.jpg"] }, "time": { "description": "Timestamp of when the occurrence happened. Must adhere to RFC 3339.", "$ref": "#/definitions/timedef", "examples": ["2018-04-05T17:31:00Z"] }, "data": { "description": "The event payload.", "$ref": "#/definitions/datadef", "examples": ["<much wow=\"xml\"/>"] }, "data_base64": { "description": "Base64 encoded event payload. Must adhere to RFC4648.", "$ref": "#/definitions/data_base64def", "examples": ["Zm9vYg=="] } }, "required": ["id", "source", "specversion", "type"], "definitions": { "iddef": { "type": "string", "minLength": 1 }, "sourcedef": { "type": "string", "format": "uri-reference", "minLength": 1 }, "specversiondef": { "type": "string", "minLength": 1 }, "typedef": { "type": "string", "minLength": 1 }, "datacontenttypedef": { "type": ["string", "null"], "minLength": 1 }, "dataschemadef": { "type": ["string", "null"], "format": "uri", "minLength": 1 }, "subjectdef": { "type": ["string", "null"], "minLength": 1 }, "timedef": { "type": ["string", "null"], "format": "date-time", "minLength": 1 }, "datadef": { "type": ["object", "string", "number", "array", "boolean", "null"] }, "data_base64def": { "type": ["string", "null"], "contentEncoding": "base64" } } };
const schema23 = { "type": "string", "minLength": 1 };
const schema24 = { "type": "string", "format": "uri-reference", "minLength": 1 };
const schema25 = { "type": "string", "minLength": 1 };
const schema26 = { "type": "string", "minLength": 1 };
const schema27 = { "type": ["string", "null"], "minLength": 1 };
const schema28 = { "type": ["string", "null"], "format": "uri", "minLength": 1 };
const schema29 = { "type": ["string", "null"], "minLength": 1 };
const schema30 = { "type": ["string", "null"], "format": "date-time", "minLength": 1 };
const schema31 = { "type": ["object", "string", "number", "array", "boolean", "null"] };
const schema32 = { "type": ["string", "null"], "contentEncoding": "base64" };
const func4 = require("ajv/dist/runtime/ucs2length").default;
const formats0 = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
const formats2 = require("ajv-formats/dist/formats").fullFormats.uri;
const formats4 = require("ajv-formats/dist/formats").fullFormats["date-time"];
function validate20(data, { instancePath = "", parentData, parentDataProperty, rootData = data } = {}) { let vErrors = null; let errors = 0; if (errors === 0) {
    if (data && typeof data == "object" && !Array.isArray(data)) {
        let missing0;
        if (((((data.id === undefined) && (missing0 = "id")) || ((data.source === undefined) && (missing0 = "source"))) || ((data.specversion === undefined) && (missing0 = "specversion"))) || ((data.type === undefined) && (missing0 = "type"))) {
            validate20.errors = [{ instancePath, schemaPath: "#/required", keyword: "required", params: { missingProperty: missing0 }, message: "must have required property '" + missing0 + "'" }];
            return false;
        }
        else {
            if (data.id !== undefined) {
                let data0 = data.id;
                const _errs1 = errors;
                const _errs2 = errors;
                if (errors === _errs2) {
                    if (typeof data0 === "string") {
                        if (func4(data0) < 1) {
                            validate20.errors = [{ instancePath: instancePath + "/id", schemaPath: "#/definitions/iddef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                            return false;
                        }
                    }
                    else {
                        validate20.errors = [{ instancePath: instancePath + "/id", schemaPath: "#/definitions/iddef/type", keyword: "type", params: { type: "string" }, message: "must be string" }];
                        return false;
                    }
                }
                var valid0 = _errs1 === errors;
            }
            else {
                var valid0 = true;
            }
            if (valid0) {
                if (data.source !== undefined) {
                    let data1 = data.source;
                    const _errs4 = errors;
                    const _errs5 = errors;
                    if (errors === _errs5) {
                        if (errors === _errs5) {
                            if (typeof data1 === "string") {
                                if (func4(data1) < 1) {
                                    validate20.errors = [{ instancePath: instancePath + "/source", schemaPath: "#/definitions/sourcedef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                                    return false;
                                }
                                else {
                                    if (!(formats0.test(data1))) {
                                        validate20.errors = [{ instancePath: instancePath + "/source", schemaPath: "#/definitions/sourcedef/format", keyword: "format", params: { format: "uri-reference" }, message: "must match format \"" + "uri-reference" + "\"" }];
                                        return false;
                                    }
                                }
                            }
                            else {
                                validate20.errors = [{ instancePath: instancePath + "/source", schemaPath: "#/definitions/sourcedef/type", keyword: "type", params: { type: "string" }, message: "must be string" }];
                                return false;
                            }
                        }
                    }
                    var valid0 = _errs4 === errors;
                }
                else {
                    var valid0 = true;
                }
                if (valid0) {
                    if (data.specversion !== undefined) {
                        let data2 = data.specversion;
                        const _errs7 = errors;
                        const _errs8 = errors;
                        if (errors === _errs8) {
                            if (typeof data2 === "string") {
                                if (func4(data2) < 1) {
                                    validate20.errors = [{ instancePath: instancePath + "/specversion", schemaPath: "#/definitions/specversiondef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                                    return false;
                                }
                            }
                            else {
                                validate20.errors = [{ instancePath: instancePath + "/specversion", schemaPath: "#/definitions/specversiondef/type", keyword: "type", params: { type: "string" }, message: "must be string" }];
                                return false;
                            }
                        }
                        var valid0 = _errs7 === errors;
                    }
                    else {
                        var valid0 = true;
                    }
                    if (valid0) {
                        if (data.type !== undefined) {
                            let data3 = data.type;
                            const _errs10 = errors;
                            const _errs11 = errors;
                            if (errors === _errs11) {
                                if (typeof data3 === "string") {
                                    if (func4(data3) < 1) {
                                        validate20.errors = [{ instancePath: instancePath + "/type", schemaPath: "#/definitions/typedef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                                        return false;
                                    }
                                }
                                else {
                                    validate20.errors = [{ instancePath: instancePath + "/type", schemaPath: "#/definitions/typedef/type", keyword: "type", params: { type: "string" }, message: "must be string" }];
                                    return false;
                                }
                            }
                            var valid0 = _errs10 === errors;
                        }
                        else {
                            var valid0 = true;
                        }
                        if (valid0) {
                            if (data.datacontenttype !== undefined) {
                                let data4 = data.datacontenttype;
                                const _errs13 = errors;
                                const _errs14 = errors;
                                if ((typeof data4 !== "string") && (data4 !== null)) {
                                    validate20.errors = [{ instancePath: instancePath + "/datacontenttype", schemaPath: "#/definitions/datacontenttypedef/type", keyword: "type", params: { type: schema27.type }, message: "must be string,null" }];
                                    return false;
                                }
                                if (errors === _errs14) {
                                    if (typeof data4 === "string") {
                                        if (func4(data4) < 1) {
                                            validate20.errors = [{ instancePath: instancePath + "/datacontenttype", schemaPath: "#/definitions/datacontenttypedef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                                            return false;
                                        }
                                    }
                                }
                                var valid0 = _errs13 === errors;
                            }
                            else {
                                var valid0 = true;
                            }
                            if (valid0) {
                                if (data.dataschema !== undefined) {
                                    let data5 = data.dataschema;
                                    const _errs16 = errors;
                                    const _errs17 = errors;
                                    if ((typeof data5 !== "string") && (data5 !== null)) {
                                        validate20.errors = [{ instancePath: instancePath + "/dataschema", schemaPath: "#/definitions/dataschemadef/type", keyword: "type", params: { type: schema28.type }, message: "must be string,null" }];
                                        return false;
                                    }
                                    if (errors === _errs17) {
                                        if (errors === _errs17) {
                                            if (typeof data5 === "string") {
                                                if (func4(data5) < 1) {
                                                    validate20.errors = [{ instancePath: instancePath + "/dataschema", schemaPath: "#/definitions/dataschemadef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                                                    return false;
                                                }
                                                else {
                                                    if (!(formats2(data5))) {
                                                        validate20.errors = [{ instancePath: instancePath + "/dataschema", schemaPath: "#/definitions/dataschemadef/format", keyword: "format", params: { format: "uri" }, message: "must match format \"" + "uri" + "\"" }];
                                                        return false;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    var valid0 = _errs16 === errors;
                                }
                                else {
                                    var valid0 = true;
                                }
                                if (valid0) {
                                    if (data.subject !== undefined) {
                                        let data6 = data.subject;
                                        const _errs19 = errors;
                                        const _errs20 = errors;
                                        if ((typeof data6 !== "string") && (data6 !== null)) {
                                            validate20.errors = [{ instancePath: instancePath + "/subject", schemaPath: "#/definitions/subjectdef/type", keyword: "type", params: { type: schema29.type }, message: "must be string,null" }];
                                            return false;
                                        }
                                        if (errors === _errs20) {
                                            if (typeof data6 === "string") {
                                                if (func4(data6) < 1) {
                                                    validate20.errors = [{ instancePath: instancePath + "/subject", schemaPath: "#/definitions/subjectdef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                                                    return false;
                                                }
                                            }
                                        }
                                        var valid0 = _errs19 === errors;
                                    }
                                    else {
                                        var valid0 = true;
                                    }
                                    if (valid0) {
                                        if (data.time !== undefined) {
                                            let data7 = data.time;
                                            const _errs22 = errors;
                                            const _errs23 = errors;
                                            if ((typeof data7 !== "string") && (data7 !== null)) {
                                                validate20.errors = [{ instancePath: instancePath + "/time", schemaPath: "#/definitions/timedef/type", keyword: "type", params: { type: schema30.type }, message: "must be string,null" }];
                                                return false;
                                            }
                                            if (errors === _errs23) {
                                                if (errors === _errs23) {
                                                    if (typeof data7 === "string") {
                                                        if (func4(data7) < 1) {
                                                            validate20.errors = [{ instancePath: instancePath + "/time", schemaPath: "#/definitions/timedef/minLength", keyword: "minLength", params: { limit: 1 }, message: "must NOT have fewer than 1 characters" }];
                                                            return false;
                                                        }
                                                        else {
                                                            if (!(formats4.validate(data7))) {
                                                                validate20.errors = [{ instancePath: instancePath + "/time", schemaPath: "#/definitions/timedef/format", keyword: "format", params: { format: "date-time" }, message: "must match format \"" + "date-time" + "\"" }];
                                                                return false;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            var valid0 = _errs22 === errors;
                                        }
                                        else {
                                            var valid0 = true;
                                        }
                                        if (valid0) {
                                            if (data.data !== undefined) {
                                                let data8 = data.data;
                                                const _errs25 = errors;
                                                if ((((typeof data8 != "object") && (typeof data8 !== "string")) && (!((typeof data8 == "number") && (isFinite(data8))))) && (typeof data8 !== "boolean")) {
                                                    validate20.errors = [{ instancePath: instancePath + "/data", schemaPath: "#/definitions/datadef/type", keyword: "type", params: { type: schema31.type }, message: "must be object,string,number,array,boolean,null" }];
                                                    return false;
                                                }
                                                var valid0 = _errs25 === errors;
                                            }
                                            else {
                                                var valid0 = true;
                                            }
                                            if (valid0) {
                                                if (data.data_base64 !== undefined) {
                                                    let data9 = data.data_base64;
                                                    const _errs28 = errors;
                                                    if ((typeof data9 !== "string") && (data9 !== null)) {
                                                        validate20.errors = [{ instancePath: instancePath + "/data_base64", schemaPath: "#/definitions/data_base64def/type", keyword: "type", params: { type: schema32.type }, message: "must be string,null" }];
                                                        return false;
                                                    }
                                                    var valid0 = _errs28 === errors;
                                                }
                                                else {
                                                    var valid0 = true;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    else {
        validate20.errors = [{ instancePath, schemaPath: "#/type", keyword: "type", params: { type: "object" }, message: "must be object" }];
        return false;
    }
} validate20.errors = vErrors; return errors === 0; }
