/**
 * Represents a builder proxy
 */
export declare type Builder<T> = {
    build: () => T;
} & {
    [k in T extends T ? keyof T : never]-?: (arg: T[k]) => Builder<T>;
};
/**
 * A factory for builders that proxy properties assignations and validate against schema on build
 * @param {Function} buildingFn The function used to validate and produce the object on build()
 * @returns {Builder} A builder proxy
 */
export declare function builder<T>(buildingFn?: (data: Partial<T>) => () => T): Builder<T>;
//# sourceMappingURL=builder.d.ts.map