import { Action } from './action';
import { End } from './end';
import { Error } from './error';
import { Eventdatafilter } from './eventdatafilter';
import { Metadata } from './metadata';
import { Statedatafilter } from './statedatafilter';
import { Transition } from './transition';
import { ActionExecTimeout, EventTimeout } from './types';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Callbackstate {
    sourceModel?: Callbackstate;
    /**
     * Unique state id
     */
    id?: string;
    /**
     * State name
     */
    name?: string;
    /**
     * State type
     */
    type?: 'callback';
    /**
     * Defines the action to be executed
     */
    action?: Action;
    /**
     * References an unique callback event name in the defined workflow events
     */
    eventRef?: string;
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
        actionExecTimeout?: ActionExecTimeout;
        eventTimeout?: EventTimeout;
    };
    /**
     * Event data filter
     */
    eventDataFilter?: Eventdatafilter;
    /**
     * State data filter
     */
    stateDataFilter?: Statedatafilter;
    /**
     * States error handling definitions
     */
    onErrors?: Error[];
    /**
     * Next transition of the workflow after all the actions have been performed
     */
    transition?: string | Transition;
    /**
     * State end definition
     */
    end?: boolean | End;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    /**
     * If true, this state is used to compensate another state. Default is false
     */
    usedForCompensation?: boolean;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Callbackstate} without deleted properties.
     */
    normalize: () => Callbackstate;
}
//# sourceMappingURL=callbackstate.d.ts.map