import { Defaultconditiondef } from './defaultconditiondef';
import { Error } from './error';
import { Metadata } from './metadata';
import { Statedatafilter } from './statedatafilter';
import { Datacondition } from './types';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Databasedswitchstate {
    sourceModel?: Databasedswitchstate;
    /**
     * Unique State id
     */
    id?: string;
    /**
     * State name
     */
    name: string;
    /**
     * State type
     */
    type: 'switch';
    /**
     * State data filter
     */
    stateDataFilter?: Statedatafilter;
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
    };
    /**
     * Defines conditions evaluated against state data
     */
    dataConditions: Datacondition[];
    /**
     * States error handling definitions
     */
    onErrors?: Error[];
    /**
     * Default transition of the workflow if there is no matching data conditions. Can include a transition or end definition
     */
    defaultCondition: Defaultconditiondef;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    /**
     * If true, this state is used to compensate another state. Default is false
     */
    usedForCompensation?: boolean;
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Databasedswitch} without deleted properties.
     */
    normalize: () => Databasedswitchstate;
}
//# sourceMappingURL=databasedswitchstate.d.ts.map