import { Metadata } from './metadata';
import { CorrelationDefs } from './types';
export declare class Eventdef {
    sourceModel?: Eventdef;
    /**
     * Unique event name
     */
    name?: string;
    /**
     * CloudEvent source
     */
    source?: string;
    /**
     * CloudEvent type
     */
    type?: string;
    /**
     * Defines the CloudEvent as either 'consumed' or 'produced' by the workflow. Default is 'consumed'
     */
    kind?: 'consumed' | 'produced';
    /**
     * CloudEvent correlation definitions
     */
    correlation?: CorrelationDefs;
    /**
     * If `true`, only the Event payload is accessible to consuming Workflow states. If `false`, both event payload and context attributes should be accessible
     */
    dataOnly?: boolean;
    /**
     * Metadata information
     */
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Eventdef} without deleted properties.
     */
    normalize: () => Eventdef;
}
//# sourceMappingURL=eventdef.d.ts.map