import { Action } from './action';
import { End } from './end';
import { Error } from './error';
import { Metadata } from './metadata';
import { Statedatafilter } from './statedatafilter';
import { Transition } from './transition';
import { ActionExecTimeout } from './types';
import { StateExecTimeout } from './stateExecTimeout';
export declare class Foreachstate {
    sourceModel?: Foreachstate;
    /**
     * Unique State id
     */
    id?: string;
    /**
     * State name
     */
    name?: string;
    /**
     * State type
     */
    type?: 'foreach';
    /**
     * State end definition
     */
    end?: boolean | End;
    /**
     * Workflow expression selecting an array element of the states data
     */
    inputCollection?: string;
    /**
     * Workflow expression specifying an array element of the states data to add the results of each iteration
     */
    outputCollection?: string;
    /**
     * Name of the iteration parameter that can be referenced in actions/workflow. For each parallel iteration, this param should contain an unique element of the inputCollection array
     */
    iterationParam?: string;
    /**
     * Specifies how many iterations may run in parallel at the same time. Used if 'mode' property is set to 'parallel' (default)
     */
    batchSize?: number | string;
    /**
     * Actions to be executed for each of the elements of inputCollection
     */
    actions?: Action[];
    /**
     * State specific timeouts
     */
    timeouts?: {
        stateExecTimeout?: StateExecTimeout;
        actionExecTimeout?: ActionExecTimeout;
    };
    /**
     * State data filter
     */
    stateDataFilter?: Statedatafilter;
    /**
     * States error handling definitions
     */
    onErrors?: Error[];
    /**
     * Next transition of the workflow after state has completed
     */
    transition?: string | Transition;
    /**
     * Unique Name of a workflow state which is responsible for compensation of this state
     */
    compensatedBy?: string;
    /**
     * If true, this state is used to compensate another state. Default is false
     */
    usedForCompensation?: boolean;
    /**
     * Specifies how iterations are to be performed (sequentially or in parallel)
     */
    mode?: 'sequential' | 'parallel';
    metadata?: Metadata;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Foreachstate} without deleted properties.
     */
    normalize: () => Foreachstate;
}
//# sourceMappingURL=foreachstate.d.ts.map