export declare class Functionref {
    sourceModel?: Functionref;
    /**
     * Name of the referenced function
     */
    refName: string;
    /**
     * Function arguments/inputs
     */
    arguments?: {
        [key: string]: any;
    };
    /**
     * Only used if function type is 'graphql'. A string containing a valid GraphQL selection set
     */
    selectionSet?: string;
    /**
     * Specifies if the function should be invoked sync or async
     */
    invoke?: 'sync' | 'async';
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Functionref} without deleted properties.
     */
    normalize: () => Functionref;
}
//# sourceMappingURL=functionref.d.ts.map