import { Action } from './action';
import { Eventdatafilter } from './eventdatafilter';
export declare class Onevents {
    sourceModel?: Onevents;
    /**
     * References one or more unique event names in the defined workflow events
     */
    eventRefs: [string, ...string[]];
    /**
     * Specifies how actions are to be performed (in sequence or in parallel)
     */
    actionMode?: 'sequential' | 'parallel';
    /**
     * Actions to be performed if expression matches
     */
    actions?: Action[];
    /**
     * Event data filter
     */
    eventDataFilter?: Eventdatafilter;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.Onevents} without deleted properties.
     */
    normalize: () => Onevents;
}
//# sourceMappingURL=onevents.d.ts.map