export declare class Retrydef {
    /**
     * Unique retry strategy name
     */
    name: string;
    /**
     * Time delay between retry attempts (ISO 8601 duration format)
     */
    delay?: string;
    /**
     * Maximum time delay between retry attempts (ISO 8601 duration format)
     */
    maxDelay?: string;
    /**
     * Static value by which the delay increases during each attempt (ISO 8601 time format)
     */
    increment?: string;
    /**
     * Numeric value, if specified the delay between retries is multiplied by this value.
     */
    multiplier?: number | string;
    /**
     * Maximum number of retry attempts.
     */
    maxAttempts: number | string;
    /**
     * If float type, maximum amount of random time added or subtracted from the delay between each retry relative to total delay (between 0 and 1). If string type, absolute maximum amount of random time added or subtracted from the delay between each retry (ISO 8601 duration format)
     */
    jitter?: number | string;
    constructor(model: any);
}
//# sourceMappingURL=retrydef.d.ts.map