import { CorrelationDef } from './correlationDef';
import { Transitiondatacondition } from './transitiondatacondition';
import { Enddatacondition } from './enddatacondition';
import { Retrydef } from './retrydef';
import { Function } from './function';
import { Databasedswitchstate } from './databasedswitchstate';
import { Eventbasedswitchstate } from './eventbasedswitchstate';
import { Transitioneventcondition } from './transitioneventcondition';
import { Enddeventcondition } from './enddeventcondition';
import { Eventstate } from './eventstate';
import { Operationstate } from './operationstate';
import { Parallelstate } from './parallelstate';
import { Injectstate } from './injectstate';
import { Foreachstate } from './foreachstate';
import { Callbackstate } from './callbackstate';
import { Eventdef } from './eventdef';
import { Sleepstate } from './sleepstate';
import { Authdef } from './authdef';
import { Errordef } from './errordef';
import { Specification } from './index';
export declare type CorrelationDefs = [
    CorrelationDef,
    ...CorrelationDef[]
];
export declare type Datacondition = Transitiondatacondition | /* Switch state data based condition */ Enddatacondition;
export declare type Retries = string | [Retrydef, ...Retrydef[]];
export declare type Functions = string | [Function, ...Function[]];
export declare type Switchstate = Databasedswitchstate | /* Permits transitions to other states based on events */ Eventbasedswitchstate;
export declare type Eventcondition = Transitioneventcondition | /* Switch state data event condition */ Enddeventcondition;
export declare type States = [
    (/* Causes the workflow execution to sleep for a specified duration */ Sleepstate | /* This state is used to wait for events from event sources, then consumes them and invoke one or more actions to run in sequence or parallel */ Eventstate | /* Defines actions be performed. Does not wait for incoming events */ Operationstate | /* Consists of a number of states that are executed in parallel */ Parallelstate | Switchstate | /* Inject static data into state data. Does not perform any actions */ Injectstate | /* Execute a set of defined actions or workflows for each element of a data array */ Foreachstate | /* This state performs an action, then waits for the callback event that denotes completion of the action */ Callbackstate),
    ...(/* Causes the workflow execution to sleep for a specified duration */ Sleepstate | /* This state is used to wait for events from event sources, then consumes them and invoke one or more actions to run in sequence or parallel */ Eventstate | /* Defines actions be performed. Does not wait for incoming events */ Operationstate | /* Consists of a number of states that are executed in parallel */ Parallelstate | Switchstate | /* Inject static data into state data. Does not perform any actions */ Injectstate | /* Execute a set of defined actions or workflows for each element of a data array */ Foreachstate | /* This state performs an action, then waits for the callback event that denotes completion of the action */ Callbackstate)[]
];
/**
 * Single branch execution timeout duration (ISO 8601 duration format)
 */
export declare type BranchExecTimeout = string;
/**
 * Single actions definition execution timeout duration (ISO 8601 duration format)
 */
export declare type ActionExecTimeout = string;
/**
 * Timeout duration to wait for consuming defined events (ISO 8601 duration format)
 */
export declare type EventTimeout = string;
export declare type Secrets = string | [string, ...string[]];
export declare type Events = string | [Eventdef, ...Eventdef[]];
export declare type Auth = string | [Authdef, ...Authdef[]];
export declare type Errors = string | [Errordef, ...Errordef[]];
export declare type Properties = Specification.Basicpropsdef | Specification.Bearerpropsdef | Specification.Oauth2propsdef;
//# sourceMappingURL=types.d.ts.map