import { Specification } from './index';
/**
 * Modify the provided object, set the value to 'schedule' property as an instance of Specification.Schedule class, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteSchedule(object: {
    schedule: string | Specification.Schedule;
}): void;
/**
 * Modify the provided object, set the value to 'start' property as an instance of Specification.Startdef class, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteStart(object: {
    start?: string | Specification.Startdef;
}): void;
/**
 * Modify the provided object, set the value to 'end' property as an instance of Specification.End class, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteEnd(object: {
    end?: boolean | Specification.End;
}): void;
/**
 * Modify the provided object, set the value to 'cron' property as an instance of Specification.Crondef class, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteCron(object: {
    cron?: string | Specification.Crondef;
}): void;
/**
 * Modify the provided object, set the value to 'transition' property as an instance of Specification.Transition class, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteTransition(object: {
    transition?: string | Specification.Transition;
}): void;
/**
 * Modify the provided object, set the value to 'defaultCondition' property as an instance of Specification.Defaultconditiondef class
 * @param object to set/overwrite the property
 */
export declare function overwriteDefaultCondition(object: {
    defaultCondition?: Specification.Defaultconditiondef;
}): void;
/**
 * Modify the provided object, set the value to 'eventConditions' property as an instance of Specification.Eventcondition[] class
 * Throws an error if provided value is neither a Transitioneventcondition nor a Enddeventcondition
 * @param object to set/overwrite the property
 */
export declare function overwriteEventConditions(object: {
    eventConditions: Specification.Eventcondition[];
}): void;
/**
 * Modify the provided object, set the value to 'dataConditions' property as an instance of Specification.Datacondition[] class
 * Throws an error if provided value is neither a Transitiondatacondition nor a Enddatacondition
 * @param object to set/overwrite the property
 */
export declare function overwriteDataConditions(object: {
    dataConditions: Specification.Datacondition[];
}): void;
/**
 * Modify the provided object, set the value to 'actions' property as an instance of Specification.Action[] class
 * @param object to set/overwrite the property
 */
export declare function overwriteActions(object: {
    actions?: Specification.Action[];
}): void;
/**
 * Modify the provided object, set the value to 'onEvents' property as an instance of Specification.Onevents[] class
 * @param object to set/overwrite the property
 */
export declare function overwriteOnEvents(object: {
    onEvents: Specification.Onevents[];
}): void;
/**
 * Modify the provided object, set the value to 'stateDataFilter' property as an instance of Specification.Statedatafilter class
 * @param object to set/overwrite the property
 */
export declare function overwriteStateDataFilter(object: {
    stateDataFilter?: Specification.Statedatafilter;
}): void;
/**
 * Modify the provided object, set the value to 'metadata' property as an instance of Specification.Metadata class
 * @param object to set/overwrite the property
 */
export declare function overwriteMetadata(object: {
    metadata?: Specification.Metadata;
}): void;
/**
 * Modify the provided object, set the value to 'retries' property as an instance of Specification.Retries class
 * @param object to set/overwrite the property
 */
export declare function overwriteRetries(object: {
    retries?: Specification.Retries;
}): void;
/**
 * Modify the provided object, set the value to 'events' property as an instance of Specification.Events class
 * @param object to set/overwrite the property
 */
export declare function overwriteEvents(object: {
    events?: Specification.Events;
}): void;
/**
 * Modify the provided object, set the value to 'errors' property as an instance of Specification.Errors class
 * @param object to set/overwrite the property
 */
export declare function overwriteErrors(object: {
    errors?: Specification.Errors;
}): void;
/**
 * Modify the provided object, set the value to 'auth' property as an instance of Specification.Auth class
 * @param object to set/overwrite the property
 */
export declare function overwriteAuth(object: {
    auth?: Specification.Auth;
}): void;
/**
 * Modify the provided object, set the value to 'functions' property as an instance of Specification.Functions class
 * @param object to set/overwrite the property
 */
export declare function overwriteFunctions(object: {
    functions?: Specification.Functions;
}): void;
/**
 * Modify the provided object, set the value to 'states' property as an instance of Specification.States class
 * Throws an error if the value of the property type is not handler
 * @param object to set/overwrite the property
 */
export declare function overwriteStates(object: {
    states: Specification.States;
}): void;
/**
 * Modify the provided object, set the value to 'properties' property as an instance of Specification.Properties class, if the provided value is an object
 * Throws an error if the value of the property type is not handler
 * @param object to set/overwrite the property
 */
export declare function overwriteProperties(object: {
    properties: string | Specification.Properties;
}): void;
/**
 * Modify the provided object, set the value to 'correlation' property as an instance of Specification.CorrelationDefs class
 * @param object to set/overwrite the property
 */
export declare function overwriteCorrelation(object: {
    correlation?: Specification.CorrelationDefs;
}): void;
/**
 * Modify the provided object, set the value to 'action' property as an instance of Specification.Action class
 * @param object to set/overwrite the property
 */
export declare function overwriteAction(object: {
    action?: Specification.Action;
}): void;
/**
 * Modify the provided object, set the value to 'workflowExecTimeout' property as an instance of Specification.WorkflowExecTimeout class
 * @param object to set/overwrite the property
 */
export declare function overwriteWorkflowExecTimeout(object: {
    workflowExecTimeout?: Specification.WorkflowExecTimeout;
}): void;
/**
 * Modify the provided object, set the value to 'stateExecTimeout' property as an instance of Specification.StateExecTimeout class
 * @param object to set/overwrite the property
 */
export declare function overwriteStateExecTimeout(object: {
    stateExecTimeout?: Specification.StateExecTimeout;
}): void;
/**
 * Modify the provided object, set the value to 'eventDataFilter' property as an instance of Specification.Eventdatafilter class
 * @param object to set/overwrite the property
 */
export declare function overwriteEventDataFilter(object: {
    eventDataFilter?: Specification.Eventdatafilter;
}): void;
/**
 * Modify the provided object, set the value to 'onErrors' property as an instance of Specification.Error[] class
 * @param object to set/overwrite the property
 */
export declare function overwriteOnErrors(object: {
    onErrors?: Specification.Error[];
}): void;
/**
 * Modify the provided object, set the value to 'branches' property as an instance of Specification.Branch[] class
 * @param object to set/overwrite the property
 */
export declare function overwriteBranches(object: {
    branches?: Specification.Branch[];
}): void;
/**
 * Modify the provided object, set the value to 'produceEvents' property as an instance of Specification.Produceeventdef[] class
 * @param object to set/overwrite the property
 */
export declare function overwriteProduceEvents(object: {
    produceEvents?: Specification.Produceeventdef[];
}): void;
/**
 * Modify the provided object, set the value to 'functionRef' property as an instance of Specification.Functionref class, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteFunctionRef(object: {
    functionRef?: string | Specification.Functionref;
}): void;
/**
 * Modify the provided object, set the value to 'continueAs' property as an instance of Specification. Continueasdef, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteContinueAs(object: {
    continueAs?: string | Specification.Continueasdef;
}): void;
/**
 * Modify the provided object, set the value to 'subFlowRef' property as an instance of Specification.Subflowref class, if the provided value is an object
 * @param object to set/overwrite the property
 */
export declare function overwriteSubFlowRef(object: {
    subFlowRef?: string | Specification.Subflowref;
}): void;
/**
 * Modify the provided object, set the value to 'eventRef' property as an instance of Specification.Eventref class
 * @param object to set/overwrite the property
 */
export declare function overwriteEventRef(object: {
    eventRef?: Specification.Eventref;
}): void;
/**
 * Modify the provided object, set the value to 'sleep' property as an instance of Specification.Sleep class
 * @param object to set/overwrite the property
 */
export declare function overwriteSleep(object: {
    sleep?: Specification.Sleep;
}): void;
/**
 * Modify the provided object, set the value to 'actionDataFilter' property as an instance of Specification.Actiondatafilter class
 * @param object to set/overwrite the property
 */
export declare function overwriteActionDataFilter(object: {
    actionDataFilter?: Specification.Actiondatafilter;
}): void;
/**
 * Set end to true if neither nor transition properties are defined
 * @param object to modify
 */
export declare function setEndValueIfNoTransition(object: {
    transition?: string | Specification.Transition;
    end?: boolean | Specification.End;
}): void;
/**
 * Modify the provided object by normalizing the 'end' property.
 * @param object to be modified
 */
export declare function normalizeEnd(object: {
    end?: boolean | Specification.End;
}): void;
/**
 * Modify the provided object, deep cloning the value of the provided property
 * @param property to be cloned
 * @param object to set/overwrite the property
 */
export declare function overwritePropertyAsPlainType(property: string, object: any): void;
/**
 * Modify the provided object, set the value to 'timeouts.stateExecTimeout' property as an instance of Specification.StateExecTimeout class,
 * for the rest of the properties the value is cloned
 * @param object to set/overwrite the property
 */
export declare function overwriteTimeoutWithStateExecTimeout(object: {
    timeouts?: {
        stateExecTimeout?: Specification.StateExecTimeout;
    };
}): void;
/**
 * Modify the provided object, set the value to 'timeouts' property as an instance of Specification.Timeouts class
 * @param object to set/overwrite the property
 */
export declare function overwriteTimeouts(object: {
    timeouts?: string | Specification.Timeouts;
}): void;
/**
 * Modify the provided object by normalizing the 'subFlowRef' property.
 * @param object to be modified
 */
export declare function normalizeSubFlowRef(object: {
    subFlowRef?: string | Specification.Subflowref;
}): void;
/**
 * Modify the provided object by normalizing the 'continueAs' property.
 * @param object to be modified
 */
export declare function normalizeContinueAs(object: {
    continueAs?: string | Specification.Continueasdef;
}): void;
/**
 * Modify the provided object by normalizing the 'defaultCondition' property.
 * @param object to be modified
 */
export declare function normalizeDefaultCondition(object: {
    defaultCondition?: Specification.Defaultconditiondef;
}): void;
/**
 * Modify the provided object by normalizing the 'workflowExecTimeout' property.
 * @param object to be modified
 */
export declare function normalizeWorkflowExecTimeout(object: {
    workflowExecTimeout?: Specification.WorkflowExecTimeout;
}): void;
/**
 * Modify the provided object by normalizing the 'onEvents' property.
 * @param object to be modified
 */
export declare function normalizeOnEvents(object: {
    onEvents: Specification.Onevents[];
}): void;
/**
 * Modify the provided object by normalizing the 'onErrors' property.
 * @param object to be modified
 */
export declare function normalizeOnErrors(object: {
    onErrors?: Specification.Error[];
}): void;
/**
 * Modify the provided object by normalizing the 'branches' property.
 * @param object to be modified
 */
export declare function normalizeBranches(object: {
    branches?: Specification.Branch[];
}): void;
/**
 * Modify the provided object by normalizing the 'actions' property.
 * @param object to be modified
 */
export declare function normalizeActions(object: {
    actions?: Specification.Action[];
}): void;
/**
 * Modify the provided object by normalizing the 'action' property.
 * @param object to be modified
 */
export declare function normalizeAction(object: {
    action?: Specification.Action;
}): void;
/**
 * Modify the provided object by normalizing the 'dataConditions' property.
 * @param object to be modified
 */
export declare function normalizeDataConditions(object: {
    dataConditions?: Specification.Datacondition[];
}): void;
/**
 * Modify the provided object by normalizing the 'eventConditions' property.
 * @param object to be modified
 */
export declare function normalizeEventConditions(object: {
    eventConditions?: Specification.Eventcondition[];
}): void;
/**
 * Modify the provided object by normalizing the 'transition' property if property type is Specification.Transition.
 * @param object to be modified
 */
export declare function normalizeTransition(object: {
    transition?: string | Specification.Transition;
}): void;
/**
 * Modify the provided object by normalizing the 'states' property.
 * @param object to be modified
 */
export declare function normalizeStates(object: {
    states: Specification.States;
}): void;
/**
 * Modify the provided object by normalizing the 'auth' property.
 * @param object to be modified
 */
export declare function normalizeAuth(object: {
    auth?: Specification.Auth;
}): void;
/**
 * Modify the provided object by normalizing the 'functions' property.
 * @param object to be modified
 */
export declare function normalizeFunctions(object: {
    functions?: Specification.Functions;
}): void;
/**
 * Modify the provided object by normalizing the 'events' property.
 * @param object to be modified
 */
export declare function normalizeEvents(object: {
    events?: Specification.Events;
}): void;
/**
 * Modify the provided object by normalizing the 'timeouts' property.
 * @param object to be modified
 */
export declare function normalizeTimeouts(object: {
    timeouts?: string | Specification.Timeouts;
}): void;
/**
 * Modify the provided object by normalizing the 'eventRef' property.
 * @param object to be modified
 */
export declare function normalizeEventRef(object: {
    eventRef?: Specification.Eventref;
}): void;
/**
 * Modify the provided object by normalizing the 'functionRef' property.
 * @param object to be modified
 */
export declare function normalizeFunctionRef(object: {
    functionRef?: string | Specification.Functionref;
}): void;
/**
 * Modify the provided object by normalizing the 'actionMode' property.
 * @param object to be modified
 */
export declare function normalizeActionMode(target: {
    actionMode?: string;
}, source?: {
    actionMode?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'completionType' property.
 * @param object to be modified
 */
export declare function normalizeCompletionType(object: {
    completionType?: string;
}, source?: {
    completionType?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'usedForCompensation' property.
 * @param object to be modified
 */
export declare function normalizeUsedForCompensation(object: {
    usedForCompensation?: boolean;
}, source?: {
    usedForCompensation?: boolean;
}): void;
/**
 * Modify the provided object by normalizing the 'mode' property.
 * @param object to be modified
 */
export declare function normalizeMode(object: {
    mode?: string;
}, source?: {
    mode?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'compensate' property.
 * @param object to be modified
 */
export declare function normalizeCompensate(object: {
    compensate?: boolean;
}, source?: {
    compensate?: boolean;
}): void;
/**
 * Modify the provided object by normalizing the 'scheme' property.
 * @param object to be modified
 */
export declare function normalizeScheme(object: {
    scheme?: string;
}, source?: {
    scheme?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'terminate' property.
 * @param object to be modified
 */
export declare function normalizeTerminate(object: {
    terminate?: boolean;
}, source?: {
    terminate?: boolean;
}): void;
/**
 * Modify the provided object by normalizing the 'exclusive' property.
 * @param object to be modified
 */
export declare function normalizeExclusive(object: {
    exclusive?: boolean;
}, source?: {
    exclusive?: boolean;
}): void;
/**
 * Modify the provided object by normalizing the 'keepActive' property.
 * @param object to be modified
 */
export declare function normalizeKeepActive(object: {
    keepActive?: boolean;
}, source?: {
    keepActive?: boolean;
}): void;
/**
 * Modify the provided object by normalizing the 'expressionLang' property.
 * @param object to be modified
 */
export declare function normalizeExpressionLang(object: {
    expressionLang?: string;
}, source?: {
    expressionLang?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'interrupt' property.
 * @param object to be modified
 */
export declare function normalizeInterrupt(object: {
    interrupt?: boolean;
}, source?: {
    interrupt?: boolean;
}): void;
/**
 * Modify the provided object by normalizing the 'type' property.
 * @param object to be modified
 */
export declare function normalizeType(object: {
    type?: string;
}, source?: {
    type?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'invoke' property.
 * @param object to be modified
 */
export declare function normalizeInvoke(object: {
    invoke?: string;
}, source?: {
    invoke?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'onParentComplete' property.
 * @param object to be modified
 */
export declare function normalizeOnParentComplete(object: {
    onParentComplete?: 'continue' | 'terminate';
}, source?: {
    onParentComplete?: 'continue' | 'terminate';
}): void;
/**
 * Modify the provided object by normalizing the 'kind' property.
 * @param object to be modified
 */
export declare function normalizeKind(object: {
    kind?: string;
}, source?: {
    kind?: string;
}): void;
/**
 * Modify the provided object by normalizing the 'dataOnly' property.
 * @param object to be modified
 */
export declare function normalizeDataOnly(object: {
    dataOnly?: boolean;
}, source?: {
    dataOnly?: boolean;
}): void;
/**
 * Modify the provided object by deleting the 'source' property
 * @param object
 */
export declare function cleanSourceModelProperty(object?: {
    sourceModel?: any;
}): void;
//# sourceMappingURL=utils.d.ts.map