export declare class WorkflowExecTimeout {
    sourceModel?: WorkflowExecTimeout;
    /**
     * Workflow execution timeout duration (ISO 8601 duration format). If not specified should be 'unlimited'
     */
    duration: string;
    /**
     * If `false`, workflow instance is allowed to finish current execution. If `true`, current workflow execution is abrupted.
     */
    interrupt?: boolean;
    /**
     * Name of a workflow state to be executed before workflow instance is terminated
     */
    runBefore?: string;
    constructor(model: any);
    /**
     * Normalize the value of each property by recursively deleting properties whose value is equal to its default value. Does not modify the object state.
     * @returns {Specification.WorkflowExecTimeout} without deleted properties.
     */
    normalize: () => WorkflowExecTimeout;
}
//# sourceMappingURL=workflowExecTimeout.d.ts.map